<?php

namespace App\Http\Controllers\Admin;

use App\Models\Page;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Cviebrock\EloquentSluggable\Services\SlugService;
use Illuminate\Support\Str;
use Image;

class PageController extends Controller
{

 // function __construct()
 //     {
 //         $this->middleware('permission:page-index|page-create|page-edit|page-delete', ['only' => ['index','show']]);
 //         $this->middleware('permission:page-create', ['only' => ['create','store']]);
 //         $this->middleware('permission:page-edit', ['only' => ['edit','update']]);
 //         $this->middleware('permission:page-delete', ['only' => ['destroy']]);
 //     }



    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.page.index');
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.page.create');
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       

        if($request->hasFile('image')==null && $request->hasFile('icon')==null ){
            Page::create([
        "name" => $request->name,
        "position"=> $request->position_type,
        "type"=> $request->page_type,
        "short_description" => $request->short_description,
        "description" => $request->description,
        "link" => $request->link,
        "parent_id"=> $request->parent_id,
        "banner" =>null,
        "display_type"=> $request->display_type,
        "icon" => $request->icon,
        "weight"=> $request->weight,
        "status" => $request->status,
        "meta_title"=> $request->meta_title,
        "meta_description" => $request->meta_description,
        "meta_keyword" => $request->meta_keyword,
        'slug' =>  Str::slug($request->name,'-')
         ]);
           }else{
           
     
        $logo=$request->image->store('posts'); 
        $icon=$request->icon->store('posts'); 
        $image=Image::make(public_path("storage/{$icon}"))->fit(1920,588);
        $image->save();
         
      
         Page::create([
            "name" => $request->name,
            "position"=> $request->position_type,
            "type"=> $request->page_type,
            "short_description" => $request->short_description,
            "description" => $request->description,
            "link" => $request->link,
            "parent_id"=> $request->parent_id,
            "banner" =>$logo,
            "display_type"=> $request->display_type,
            "icon" => $icon,
            "weight"=> $request->weight,
            "status" => $request->status,
            "meta_title"=> $request->meta_title,
            "meta_description" => $request->meta_description,
            "meta_keyword" => $request->meta_keyword,
            'slug' => Str::slug($request->name,'-')
       
      
       ]);
       }  
           
            return redirect( route('page.index'))->with('success','pages created successfully.');

        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Page $page)
    {
        return view('admin.page.show',compact('page'));
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Page $page)
    {
        return view('admin.page.edit',compact('page'));
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,Page $page)
    {
        $data=$request->only(['name','position','type','short_description','description','link','parent_id','display_type','icon','weight','status',
        'meta_title','meta_description','meta_keyword','slug']);



        if($request->hasfile('image') && $request->hasFile('icon') ){
            $logo=$request->image->store('posts');
            $icon=$request->icon->store('posts');
            $image=Image::make(public_path("storage/{$icon}"))->fit(1920,588);
            $image->save();
            Storage::delete($page->icon);
            Storage::delete($page->banner);
             $data['banner'] = $logo;
             $data['icon'] = $icon;
             }

             if($request->hasfile('image')){
                $logo=$request->image->store('posts');
                Storage::delete($page->banner);
                 $data['banner'] = $logo;
                 }

                 if($request->hasFile('icon') ){
                    $icon=$request->icon->store('posts');
                    $image=Image::make(public_path("storage/{$icon}"))->fit(1920,588);
                    $image->save();
                    Storage::delete($page->icon);
                     $data['icon'] = $icon;
                     }



             $page->update($data);
             session()->flash('success','page upated successfully.');
               return redirect( route('page.index') );
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Page $page)
    {
        $page->delete();
        session()->flash('error','pages deleted successfully.');
               return redirect( route('page.index') );
        //
    }

      public function status($id){
      
           $page=Page::find($id);  
        if($page->status== 1){
            $page->status = 0;
        }else{
            $page->status =1;
        }
        session()->flash('success','status has been succesfully updated');
        $page->save();
            return redirect(route('page.index'));
      }

}
